//the blue sun's house

//stucco
#declare stuccoTex = texture {
	pigment {
		color (White+Yellow)/2
	}
	normal {
		wrinkles 2
		scale .008
	}
	finish {
		ambient .4
	}
}

/*#declare stuccoColor = color (White+Yellow*2)/3;

#declare stuccoTex = texture {
    pigment {
        granite
        color_map {
            [0.0 rgb stuccoColor*.9 ]
            [1.0 rgb stuccoColor]
        }
        scale 0.075
    }
    normal  { granite 0.75 scale 0.075 }
}
texture {
    pigment {
        wrinkles
        turbulence 0.3
        scale 0.3
        color_map {
            [0.0 rgbt< 0.80, 0.75, 0.60, 0.95>]
            [1.0 rgbt< 0.95, .85, 0.90, 0.95>]
        }
    }
}
#declare stuccoTex = texture { stuccoTex scale .1 }
*/

#declare roofTex = texture {
	pigment {
		color Tan
	}
	normal {
		brick 2
		scale .1
	}
}

#declare square = 5*feet;
#declare wallThickness = .65*feet;
#declare basementDepth = -2;
#declare wallHeight = 9*feet;
#declare walls = union {
	//main wall
	box {
		<-3.75*square, basementDepth, -wallThickness>
		<3.75*square, wallHeight, 0>
	}
	
	//foyer walls
	//foyer west
	box {
		<-1.25*square, basementDepth, -4*square>
		<-1.25*square+wallThickness, wallHeight, 2*square>
	}
	//foyer east
	box {
		<1.5*square, basementDepth, 0>
		<1.5*square+wallThickness, wallHeight, 2*square>
	}
	//foyer north
	box {
		<-1.25*square, basementDepth, 2*square>
		<1.5*square, wallHeight, 2*square+wallThickness>
	}

	//east ell
	//east ell east
	box {
		<3.75*square-wallThickness, basementDepth, 0>
		<3.75*square, wallHeight, -4.2*square>
	}
	//east ell west
	box {
		<1.25*square, basementDepth, 0>
		<1.25*square-wallThickness, wallHeight, -4.2*square>
	}
	//east ell south
	box {
		<1.25*square, basementDepth, -4.2*square+wallThickness>
		<3.75*square, wallHeight, -4.2*square>
	}
	
	//middle south
	box {
		<-1.25*square, basementDepth, -2*square>
		<3.75*square, wallHeight, -2*square-wallThickness>
	}
	
	//west ell
	//west ell west
	box {
		<-3.75*square, basementDepth, -4*square>
		<-3.75*square+wallThickness, wallHeight, 0>
	}
	//west ell south
	box {
		<-5.25*square, basementDepth, -4*square>
		<-1.25*square, wallHeight, -4*square+wallThickness>
	}
	//west ell add-on west
	box {
		<-5.25*square, basementDepth, -4*square>
		<-5.25*square+wallThickness, wallHeight, -2*square>
	}
	//west ell add-on north
	box {
		<-5.25*square, basementDepth, -2*square>
		<-3.75*square, wallHeight, -2*square+wallThickness>
	}
	
	clipped_by {
		plane {
			y, 0
			rotate <4, 0, 0>
			translate <0, wallHeight-2*feet, 0>
		}
	}
}

#declare overHang = 5*inches;

#declare roof = prism {
	linear_spline
	linear_sweep
	0, wallThickness
	15

	//foyer northwest
	<-1.25*square, 2*square>+<-overHang, overHang>
	//foyer northeast
	<1.5*square, 2*square>+overHang
	//foyer southeast
	<1.5*square, 0*square>+overHang
	//east ell northeast
	<3.75*square, 0*square>+overHang
	//east ell southeast
	<3.75*square, -4.2*square>+<overHang, -overHang>
	//east ell southwest
	<1.25*square-wallThickness, -4.2*square>+<-overHang, -overHang>
	//nook northeast
	<1.25*square-wallThickness, -2*square-wallThickness>+<-overHang, -overHang>
	//nook northwest
	<-1.25*square+wallThickness, -2*square-wallThickness>+<overHang, -overHang>
	//west ell southeast
	<-1.25*square+wallThickness, -4*square>+<overHang, -overHang>
	//west add-on southwest
	<-5.25*square, -4*square>+<-overHang, -overHang>
	//west add-on northwest
	<-5.25*square, -2*square>+<-overHang, overHang>
	//west add-on northeast
	<-3.75*square, -2*square>+<-overHang, overHang>
	//west ell northwest
	<-3.75*square, 0*square>+<-overHang, overHang>
	//west ell northeast
	<-1.25*square, 0*square>+<-overHang, overHang>
	//foyer northwest reconnect
	<-1.25*square, 2*square>+<-overHang, overHang>
	
	rotate <4, 0, 0>
	translate <0, wallHeight-2*feet, 0>
	
	texture { roofTex }
}

//windows
#declare windowScale = .12;
#declare windowHeight = 3*feet;

#declare rd=seed(18908);
//width of shutter
#declare xL=3;

//height of window
#declare yL=9;

//color of siding
#declare T_TF=texture{pigment{color rgb <1, .1, .1>}}

//color of shutters
#declare T_V1=texture{
	pigment{
		color White
	}
	finish {
		ambient .4
	}
}

//color of pane frames
#declare T_Window1=texture{pigment{Yellow}}

#declare T_Window2=texture{pigment{White}}
#declare T_Glass1=texture{pigment{Clear}}
#declare T_Balcony1=texture{pigment{Green*0.3}}
#declare T_Balcony2=texture{pigment{rgb<1,0.9,0.8>*1.3}}
#declare T_Balcony2=texture{pigment{rgb<1,0.9,0.8>*1.3}}
#declare T_Roof=texture{pigment{rgb<0.8,0.7,0.9>*0.3}}
#declare T_V2=texture{pigment{rgb<1,0.8,0.5>}}

#include "mwindow.pov"

#declare shutterClosed=object{mShutter(3,xL,yL,0.2,0.3,20,5,5,6,0.7,0.1,rd,0.5,T_V1)}
#declare shutterOpened=object{mShutter(3,xL,yL,0.2,0.3,20,175,155,165,0.7,0.1,rd,0.5,T_V1)}

#declare windowClosed=object{mWindow(2,xL,yL,0.2,0.3,0.1,0.1,0,2,0,0,0.5,0.1,T_Window1,T_Window2,T_Glass1)}
#declare windowOpened=object{mWindow(2,xL,yL,0.2,0.3,0.1,0.1,0,2,-40,-50,0.5,0.1,T_Window1,T_Window2,T_Glass1)}

#declare windowCase=object{mWindowCase(4,xL,yL,0.4,1,0.1,0.6,0,  0,0.5,0.5,T_TF,T_Roof)}

#declare openWindow = union {
	object { windowOpened }
	object { shutterOpened }
	object { windowCase }
	scale windowScale
	translate <0, windowHeight, 0>
}
#declare closedWindow = union {
	object { windowClosed }
	object { shutterClosed }
	object { windowCase }
	scale windowScale
	translate <0, windowHeight, 0>
}
#declare windowBox = box {
	<-xL, 0, -.001>
	<xL, yL, wallThickness*1.1>
	scale <windowScale, windowScale, 1>
	translate <0, windowHeight, 0>
}

#declare windowNookWest = transform {
	rotate <0, -90, 0>
	translate <-1.25*square+wallThickness, 0, -3*square>
}
#declare windowNookSouth = transform {
	translate <0*square, 0, -2*square-wallThickness>
}
#declare windowNookEast = transform {
	rotate <0, 90, 0>
	translate <1.25*square-wallThickness, 0, -3*square>
}
#declare windowFoyerWest = transform {
	rotate <0, 90, 0>
	translate <-1.25*square, -1*feet, 1.25*square>
}
#declare windowFoyerEast = transform {
	rotate <0, -90, 0>
	translate <1.55*square+wallThickness, -1*feet, 1.25*square>
}
#declare windowEastEll1 = transform {
	rotate <0, -90, 0>
	translate <3.75*square, 0, -.75*square>
}
#declare windowEastEll2 = transform {
	rotate <0, -90, 0>
	scale <1, 1, 1.75>
	translate <3.75*square, 0, -3.25*square>
}
#declare windowEastBack = transform {
	scale <1.75, 1, 1>
	translate <2.5*square, 0, -4.2*square>
}
#declare windowWestEll = transform {
	rotate <0, 90, 0>
	translate <-3.75*square, 0, -1*square>
}

#declare windowWestBack = transform {
	translate <-2.5*square, 0, -4*square>
}
#declare windowWestFront = transform {
	rotate <0, 180, 0>
	translate <-2.5*square, 0, 0*square>
}
	
#declare house = union {
	difference {
		object { walls }
		object { windowBox
			transform windowNookWest
		}
		object { windowBox
			transform windowNookSouth
		}
		object { windowBox
			transform windowNookEast
		}
		object { windowBox
			transform windowFoyerWest
		}
		object { windowBox
			transform windowFoyerEast
		}
		object { windowBox
			transform windowEastEll1
		}
		object { windowBox
			transform windowEastEll2
		}
		object { windowBox
			transform windowEastBack
		}
		object { windowBox
			transform windowWestEll
		}
		object { windowBox
			transform windowWestBack
		}
		object { windowBox
			transform windowWestFront
		}

		texture { stuccoTex }
	}

	object { roof }
	
	object { closedWindow
		transform windowNookWest
	}
	object { openWindow
		transform windowNookSouth
	}
	object { openWindow
		transform windowNookEast
	}
	object { closedWindow
		transform windowFoyerWest
	}
	object { closedWindow
		transform windowFoyerEast
	}
	object { closedWindow
		transform windowEastEll1
	}
	object { openWindow
		transform windowEastEll2
	}
	object { openWindow
		transform windowEastBack
	}
	object { closedWindow
		transform windowWestEll
	}
	object { closedWindow
		transform windowWestBack
	}
	object { closedWindow
		transform windowWestFront
	}

}


#declare crypt = box {
	<-.75*square, basementDepth, -.6*square>
	<.75*square, 7*feet, .6*square>
	texture { T_Stone23
		scale .1
	}
}

#declare houseStart = <-23, simple_radius, -25.5>;
#declare houseLoc = trace(land, houseStart, <0, -1, 0>, nvector);
